(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     35536,        764]
NotebookOptionsPosition[     35201,        747]
NotebookOutlinePosition[     35556,        763]
CellTagsIndexPosition[     35513,        760]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "NMR", " ", "Spectrum", " ", "without", " ", "Noise", " ", "component"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Note", ":", " ", "\[IndentingNewLine]", "\t  ", 
     RowBox[{
     "This", " ", "test", " ", "is", " ", "somehow", " ", "chanllenging", " ",
       "for", " ", "the", " ", 
      RowBox[{"computer", ".", "\[IndentingNewLine]", "\t", "Please"}], " ", 
      "be", " ", "patient", " ", "when", " ", "you", " ", "change", " ", 
      "the", " ", "paratmeter", " ", "in", " ", "the", " ", "control", " ", 
      RowBox[{"panel", ".", "\[IndentingNewLine]", "\t", "Especially"}], " ", 
      "when", " ", "you", " ", "set", " ", "a", " ", "high", " ", "value", 
      " ", "for", " ", "transients"}]}], ",", " ", 
    RowBox[{
    "the", " ", "program", " ", "will", " ", "last", " ", "long", " ", "with",
      " ", "every", " ", "changes", " ", "of", " ", "other", " ", 
     "parameters"}]}], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "\"\<`Global*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"t", "=", 
       RowBox[{"t0", "/", "n"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Column", "[", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
              "\"\<Free Induction Decay (Real)\>\"", ",", "\"\<Label\>\"", 
               ",", "15", ",", "Red", ",", "Bold"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Plot", "[", 
              RowBox[{
               RowBox[{"Re", "[", 
                RowBox[{
                 RowBox[{"Cos", "[", 
                  RowBox[{
                   RowBox[{"2", "*", "Pi", "*", "d", "*", "t"}], "+", 
                   "\[CurlyPhi]"}], "]"}], "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"T", "-", "b"}], ")"}], "2"]}], "/", 
                   RowBox[{"(", 
                    RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{"-", "lb"}], "*", "T"}], "]"}], "*", "A", "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{"I", "*", "2", "*", "Pi", "*", "w0", "*", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "Td"}], ")"}]}], "+", 
                   RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{"\[Psi]", "/", "180"}]}]}], "]"}], "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "Td"}], ")"}]}], "/", "T2"}], "]"}], 
                 "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{"I", "*", "Pi", "*", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Psi]", "-", "\[Psi]c"}], ")"}], "/", "180"}]}],
                   "]"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"T", ",", "0", ",", "t0"}], "}"}], ",", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "t0"}], "}"}], ",", "All"}], "}"}]}], 
               ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<t (s)\>\"", ",", "16", ",", "Italic"}], "]"}]}],
                ",", 
               RowBox[{"PlotStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Red", ",", 
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
               ",", 
               RowBox[{"ImageSize", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"400", ",", "200"}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
              "\"\<Frequency Spectrum (Real)\>\"", ",", "\"\<Label\>\"", ",", 
               "15", ",", "Red", ",", "Bold"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Plot", "[", 
              RowBox[{
               RowBox[{"Sum", "[", 
                RowBox[{
                 RowBox[{"Re", "[", 
                  RowBox[{
                   RowBox[{"Cos", "[", 
                    RowBox[{
                    RowBox[{"2", "*", "Pi", "*", "d", "*", "k", "*", "t"}], 
                    "+", "\[CurlyPhi]"}], "]"}], "*", 
                   RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", "*", "t"}], "-", "b"}], ")"}], "2"]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                   RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}], "*", 
                   "A", "*", 
                   RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"I", "*", "2", "*", "Pi", "*", 
                    RowBox[{"(", 
                    RowBox[{"w", "-", "w0"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "*", "k"}], "+", "Td"}], ")"}]}], "+", 
                    RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{"\[Psi]", "/", "180"}]}]}], "]"}], "*", 
                   RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "*", "k"}], "+", "Td"}], ")"}]}], "/", 
                    "T2"}], "]"}], "*", 
                   RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Psi]", "-", "\[Psi]c"}], ")"}], "/", "180"}]}],
                     "]"}]}], "]"}], "\[IndentingNewLine]", ",", 
                 RowBox[{"{", 
                  RowBox[{"k", ",", "0", ",", 
                   RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"w", ",", 
                 RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<f (Hz)\>\"", ",", "16", ",", "Italic"}], 
                 "]"}]}], ",", 
               RowBox[{"PlotStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Red", ",", 
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
               ",", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", "All"}], 
                 "}"}]}], ",", 
               RowBox[{"ImageSize", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"400", ",", "200"}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}]}], 
            "\[IndentingNewLine]", "}"}], ",", 
           RowBox[{"Alignment", "\[Rule]", "Left"}], ",", 
           RowBox[{"Spacings", "\[Rule]", "1"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Column", "[", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
              "\"\<Free Induction Decay (Imaginary)\>\"", ",", 
               "\"\<Label\>\"", ",", "15", ",", "Red", ",", "Bold"}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"Plot", "[", 
              RowBox[{
               RowBox[{"Im", "[", 
                RowBox[{
                 RowBox[{"Cos", "[", 
                  RowBox[{
                   RowBox[{"2", "*", "Pi", "*", "d", "*", "t"}], "+", 
                   "\[CurlyPhi]"}], "]"}], "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"T", "-", "b"}], ")"}], "2"]}], "/", 
                   RowBox[{"(", 
                    RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{"-", "lb"}], "*", "T"}], "]"}], "*", "A", "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{"I", "*", "2", "*", "Pi", "*", "w0", "*", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "Td"}], ")"}]}], "+", 
                   RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{"\[Psi]", "/", "180"}]}]}], "]"}], "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "Td"}], ")"}]}], "/", "T2"}], "]"}], 
                 "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{"I", "*", "Pi", "*", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Psi]", "-", "\[Psi]c"}], ")"}], "/", "180"}]}],
                   "]"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"T", ",", "0", ",", "t0"}], "}"}], ",", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "t0"}], "}"}], ",", "All"}], "}"}]}], 
               ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<t (s)\>\"", ",", "16", ",", "Italic"}], "]"}]}],
                ",", 
               RowBox[{"PlotStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Red", ",", 
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
               ",", 
               RowBox[{"ImageSize", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"400", ",", "200"}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
              "\"\<Frequency Spectrum (Imaginary)\>\"", ",", "\"\<Label\>\"", 
               ",", "15", ",", "Red", ",", "Bold"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Plot", "[", 
              RowBox[{
               RowBox[{"Sum", "[", 
                RowBox[{
                 RowBox[{"Im", "[", 
                  RowBox[{
                   RowBox[{"Cos", "[", 
                    RowBox[{
                    RowBox[{"2", "*", "Pi", "*", "d", "*", "k", "*", "t"}], 
                    "+", "\[CurlyPhi]"}], "]"}], "*", 
                   RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", "*", "t"}], "-", "b"}], ")"}], "2"]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                   RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}], "*", 
                   "A", "*", 
                   RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"I", "*", "2", "*", "Pi", "*", 
                    RowBox[{"(", 
                    RowBox[{"w", "-", "w0"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "*", "k"}], "+", "Td"}], ")"}]}], "+", 
                    RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{"\[Psi]", "/", "180"}]}]}], "]"}], "*", 
                   RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "*", "k"}], "+", "Td"}], ")"}]}], "/", 
                    "T2"}], "]"}], "*", 
                   RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Psi]", "-", "\[Psi]c"}], ")"}], "/", "180"}]}],
                     "]"}]}], "]"}], "\[IndentingNewLine]", ",", 
                 RowBox[{"{", 
                  RowBox[{"k", ",", "0", ",", 
                   RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"w", ",", 
                 RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<f (Hz)\>\"", ",", "16", ",", "Italic"}], 
                 "]"}]}], ",", 
               RowBox[{"PlotStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Red", ",", 
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
               ",", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", "All"}], 
                 "}"}]}], ",", 
               RowBox[{"ImageSize", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"400", ",", "200"}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}]}], 
            "\[IndentingNewLine]", "}"}], ",", 
           RowBox[{"Alignment", "\[Rule]", "Left"}], ",", 
           RowBox[{"Spacings", "\[Rule]", "1"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<NMR Signal and Spectrum\>\"", ",", "15", ",", "Blue", ",", " ", 
       "Bold"}], "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     "Delimiter", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Parameters of Signal\>\"", ",", "15", ",", "Blue", ",", "Bold"}], 
      "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Td", ",", "0", ",", "\"\<Delay Time, Td/s\>\""}], "}"}], ",",
        "0", ",", "2.", ",", "0.001", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t0", ",", "2", ",", "\"\<Acquition time\>\""}], "}"}], ",", 
       "0.01", ",", "10", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", "20", ",", "\"\<Number of Data Points\>\""}], "}"}],
        ",", "10", ",", "100", ",", "1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "0.25", ",", "\"\<Amplitude\>\""}], "}"}], ",", 
       "0.01", ",", "1", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w0", ",", "1", ",", "\"\<Peak Position\>\""}], "}"}], ",", 
       RowBox[{"-", "5"}], ",", "5", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Psi]", ",", "0", ",", "\"\<Initial Phase/\[Degree]\>\""}], 
        "}"}], ",", "0", ",", "360", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\[Psi]c", ",", "0", ",", "\"\<Phase correction/\[Degree]\>\""}], 
        "}"}], ",", "0", ",", "360", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"T2", ",", "2", ",", "\"\<T2 relaxation of nuclear\>\""}], 
        "}"}], ",", "0.1", ",", "5", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     "Delimiter", ",", "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Window Functions\>\"", ",", "15", ",", "Blue", ",", "Bold"}], 
      "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lb", ",", "0", ",", "\"\<Exponential Apodization\>\""}], 
        "}"}], ",", "0", ",", "2", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "c", ",", "4", ",", "\"\<Gausiian Apodization (Variance)\>\""}], 
        "}"}], ",", "0.1", ",", "4", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b", ",", "0", ",", "\"\<Gaussian Variance (Shift)\>\""}], 
        "}"}], ",", 
       RowBox[{"-", "10"}], ",", "10", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d", ",", "0", ",", "\"\<Sine Function (Peoredical)\>\""}], 
        "}"}], ",", "0", ",", "1", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\[CurlyPhi]", ",", "0", ",", "\"\<Sine Function (Shift)\>\""}], 
        "}"}], ",", "0", ",", "2", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SaveDefinitions", "\[Rule]", " ", "True"}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Exponential", " ", 
     RowBox[{"Function", ":", "\[IndentingNewLine]", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}]}]}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Gaussian", " ", 
     RowBox[{"Function", ":", "\[IndentingNewLine]", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", "*", "t"}], "-", "b"}], ")"}], "2"]}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Sin", " ", 
     RowBox[{"Function", ":", "\[IndentingNewLine]", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"d", "*", "k", "*", "t"}], "+", "\[CurlyPhi]"}], "]"}]}]}], 
    "\[IndentingNewLine]", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.538019550138421*^9, 3.538019553504799*^9}, {
   3.538019585887994*^9, 3.5380195879673567`*^9}, {3.538019619595662*^9, 
   3.538019680147975*^9}, {3.5380197617290287`*^9, 3.538019775269904*^9}, {
   3.538019805864463*^9, 3.5380198341787643`*^9}, {3.538019940558207*^9, 
   3.538020000280266*^9}, 3.5380200466355467`*^9, {3.53802007697983*^9, 
   3.53802012174336*^9}, {3.538020331568901*^9, 3.538020331797257*^9}, 
   3.538020623116501*^9, {3.538020659112328*^9, 3.538020686674403*^9}, {
   3.5380207209098043`*^9, 3.538020844961226*^9}, {3.538020883084367*^9, 
   3.538020883414212*^9}, {3.538020926758059*^9, 3.538020952939637*^9}, {
   3.538021003025251*^9, 3.53802100823885*^9}, {3.538021096520261*^9, 
   3.538021173081881*^9}, {3.538021206233158*^9, 3.538021213432673*^9}, {
   3.538021249623416*^9, 3.5380212504579287`*^9}, {3.538021282421591*^9, 
   3.538021381211609*^9}, {3.538021415164215*^9, 3.5380214311005383`*^9}, {
   3.5380214760865498`*^9, 3.5380215887683897`*^9}, {3.538021646283759*^9, 
   3.538021676498147*^9}, {3.5380217311644373`*^9, 3.538021734421472*^9}, {
   3.538021793825343*^9, 3.538021807521678*^9}, {3.538021881252643*^9, 
   3.538021888408462*^9}, {3.538021975892112*^9, 3.538022011181617*^9}, {
   3.5380220553606358`*^9, 3.538022108101372*^9}, {3.538022154213922*^9, 
   3.538022208948161*^9}, {3.538022255007969*^9, 3.538022279942182*^9}, {
   3.538022319297078*^9, 3.538022349765641*^9}, {3.538022387268468*^9, 
   3.538022389624907*^9}, {3.5380225597053337`*^9, 3.5380225948689117`*^9}, {
   3.538022631938891*^9, 3.538022633656815*^9}, {3.538022677261565*^9, 
   3.538022695975778*^9}, {3.538022767802512*^9, 3.538022769111027*^9}, {
   3.538022923435006*^9, 3.538022923793792*^9}, {3.5380230880402327`*^9, 
   3.538023103926797*^9}, {3.5380241944397173`*^9, 3.538024198175356*^9}, {
   3.538069568490336*^9, 3.538069630588125*^9}, {3.538071655498734*^9, 
   3.5380717037293663`*^9}, {3.538072863355585*^9, 3.538072924118156*^9}, {
   3.5387097029857597`*^9, 3.538709705283749*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`A$$ = 0.25, $CellContext`b$$ = 
    0, $CellContext`c$$ = 4, $CellContext`d$$ = 0, $CellContext`lb$$ = 
    0, $CellContext`n$$ = 20, $CellContext`t0$$ = 2, $CellContext`T2$$ = 
    2, $CellContext`Td$$ = 0, $CellContext`w0$$ = 
    1, $CellContext`\[CurlyPhi]$$ = 0, $CellContext`\[Psi]$$ = 
    0, $CellContext`\[Psi]c$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Style["NMR Signal and Spectrum", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Style["Parameters of Signal", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`Td$$], 0, "Delay Time, Td/s"}, 0, 2., 0.001}, {{
       Hold[$CellContext`t0$$], 2, "Acquition time"}, 0.01, 10, 0.01}, {{
       Hold[$CellContext`n$$], 20, "Number of Data Points"}, 10, 100, 1}, {{
       Hold[$CellContext`A$$], 0.25, "Amplitude"}, 0.01, 1, 0.01}, {{
       Hold[$CellContext`w0$$], 1, "Peak Position"}, -5, 5, 0.1}, {{
       Hold[$CellContext`\[Psi]$$], 0, "Initial Phase/\[Degree]"}, 0, 360, 
      0.1}, {{
       Hold[$CellContext`\[Psi]c$$], 0, "Phase correction/\[Degree]"}, 0, 360,
       0.1}, {{
       Hold[$CellContext`T2$$], 2, "T2 relaxation of nuclear"}, 0.1, 5, 
      0.01}, {
      Hold[
       Style["Window Functions", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`lb$$], 0, "Exponential Apodization"}, 0, 2, 0.01}, {{
      
       Hold[$CellContext`c$$], 4, "Gausiian Apodization (Variance)"}, 0.1, 4, 
      0.01}, {{
       Hold[$CellContext`b$$], 0, "Gaussian Variance (Shift)"}, -10, 10, 
      0.1}, {{
       Hold[$CellContext`d$$], 0, "Sine Function (Peoredical)"}, 0, 1, 
      0.01}, {{
       Hold[$CellContext`\[CurlyPhi]$$], 0, "Sine Function (Shift)"}, 0, 2, 
      0.01}}, Typeset`size$$ = {803., {230.34375, 235.65625}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`Td$1305$$ = 0, $CellContext`t0$1306$$ = 
    0, $CellContext`n$1307$$ = 0, $CellContext`A$1308$$ = 
    0, $CellContext`w0$1309$$ = 0, $CellContext`\[Psi]$1310$$ = 
    0, $CellContext`\[Psi]c$1311$$ = 0, $CellContext`T2$1312$$ = 
    0, $CellContext`lb$1313$$ = 0, $CellContext`c$1314$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`A$$ = 0.25, $CellContext`b$$ = 
        0, $CellContext`c$$ = 4, $CellContext`d$$ = 0, $CellContext`lb$$ = 
        0, $CellContext`n$$ = 20, $CellContext`t0$$ = 2, $CellContext`T2$$ = 
        2, $CellContext`Td$$ = 0, $CellContext`w0$$ = 
        1, $CellContext`\[CurlyPhi]$$ = 0, $CellContext`\[Psi]$$ = 
        0, $CellContext`\[Psi]c$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`Td$$, $CellContext`Td$1305$$, 0], 
        Hold[$CellContext`t0$$, $CellContext`t0$1306$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$1307$$, 0], 
        Hold[$CellContext`A$$, $CellContext`A$1308$$, 0], 
        Hold[$CellContext`w0$$, $CellContext`w0$1309$$, 0], 
        Hold[$CellContext`\[Psi]$$, $CellContext`\[Psi]$1310$$, 0], 
        Hold[$CellContext`\[Psi]c$$, $CellContext`\[Psi]c$1311$$, 0], 
        Hold[$CellContext`T2$$, $CellContext`T2$1312$$, 0], 
        Hold[$CellContext`lb$$, $CellContext`lb$1313$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$1314$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`t = $CellContext`t0$$/$CellContext`n$$; Row[{
          Column[{
            Style["Free Induction Decay (Real)", "Label", 15, Red, Bold], 
            Plot[
             Re[
             Cos[2 Pi $CellContext`d$$ $CellContext`t + $CellContext`\
\[CurlyPhi]$$] 
              Exp[(-($CellContext`T - $CellContext`b$$)^2)/(
                2 $CellContext`c$$)] 
              Exp[(-$CellContext`lb$$) $CellContext`T] $CellContext`A$$ 
              Exp[I 2 Pi $CellContext`w0$$ ($CellContext`T + \
$CellContext`Td$$) + I Pi ($CellContext`\[Psi]$$/180)] 
              Exp[(-($CellContext`T + $CellContext`Td$$))/$CellContext`T2$$] 
              Exp[I Pi (($CellContext`\[Psi]$$ - $CellContext`\[Psi]c$$)/
                 180)]], {$CellContext`T, 0, $CellContext`t0$$}, 
             PlotRange -> {{0, $CellContext`t0$$}, All}, Frame -> True, 
             FrameLabel -> Style["t (s)", 16, Italic], PlotStyle -> {Red, 
               AbsoluteThickness[2]}, ImageSize -> {400, 200}, AspectRatio -> 
             0.35], 
            Style["Frequency Spectrum (Real)", "Label", 15, Red, Bold], 
            Plot[
             Sum[
              Re[
              Cos[2 Pi $CellContext`d$$ $CellContext`k $CellContext`t + \
$CellContext`\[CurlyPhi]$$] 
               Exp[(-($CellContext`k $CellContext`t - $CellContext`b$$)^2)/(
                 2 $CellContext`c$$)] 
               Exp[(-$CellContext`lb$$) $CellContext`k $CellContext`t] \
$CellContext`A$$ 
               Exp[I 2 
                  Pi ($CellContext`w - $CellContext`w0$$) ($CellContext`t \
$CellContext`k + $CellContext`Td$$) + I Pi ($CellContext`\[Psi]$$/180)] 
               Exp[(-($CellContext`t $CellContext`k + \
$CellContext`Td$$))/$CellContext`T2$$] 
               Exp[I Pi (($CellContext`\[Psi]$$ - $CellContext`\[Psi]c$$)/
                  180)]], {$CellContext`k, 0, $CellContext`n$$ - 
               1}], {$CellContext`w, -5, 5}, Frame -> True, FrameLabel -> 
             Style["f (Hz)", 16, Italic], PlotStyle -> {Red, 
               AbsoluteThickness[2]}, PlotRange -> {{-5, 5}, All}, 
             ImageSize -> {400, 200}, AspectRatio -> 0.35]}, Alignment -> 
           Left, Spacings -> 1], 
          Column[{
            Style["Free Induction Decay (Imaginary)", "Label", 15, Red, Bold], 
            Plot[
             Im[
             Cos[2 Pi $CellContext`d$$ $CellContext`t + $CellContext`\
\[CurlyPhi]$$] 
              Exp[(-($CellContext`T - $CellContext`b$$)^2)/(
                2 $CellContext`c$$)] 
              Exp[(-$CellContext`lb$$) $CellContext`T] $CellContext`A$$ 
              Exp[I 2 Pi $CellContext`w0$$ ($CellContext`T + \
$CellContext`Td$$) + I Pi ($CellContext`\[Psi]$$/180)] 
              Exp[(-($CellContext`T + $CellContext`Td$$))/$CellContext`T2$$] 
              Exp[I Pi (($CellContext`\[Psi]$$ - $CellContext`\[Psi]c$$)/
                 180)]], {$CellContext`T, 0, $CellContext`t0$$}, 
             PlotRange -> {{0, $CellContext`t0$$}, All}, Frame -> True, 
             FrameLabel -> Style["t (s)", 16, Italic], PlotStyle -> {Red, 
               AbsoluteThickness[2]}, ImageSize -> {400, 200}, AspectRatio -> 
             0.35], 
            Style["Frequency Spectrum (Imaginary)", "Label", 15, Red, Bold], 
            Plot[
             Sum[
              Im[
              Cos[2 Pi $CellContext`d$$ $CellContext`k $CellContext`t + \
$CellContext`\[CurlyPhi]$$] 
               Exp[(-($CellContext`k $CellContext`t - $CellContext`b$$)^2)/(
                 2 $CellContext`c$$)] 
               Exp[(-$CellContext`lb$$) $CellContext`k $CellContext`t] \
$CellContext`A$$ 
               Exp[I 2 
                  Pi ($CellContext`w - $CellContext`w0$$) ($CellContext`t \
$CellContext`k + $CellContext`Td$$) + I Pi ($CellContext`\[Psi]$$/180)] 
               Exp[(-($CellContext`t $CellContext`k + \
$CellContext`Td$$))/$CellContext`T2$$] 
               Exp[I Pi (($CellContext`\[Psi]$$ - $CellContext`\[Psi]c$$)/
                  180)]], {$CellContext`k, 0, $CellContext`n$$ - 
               1}], {$CellContext`w, -5, 5}, Frame -> True, FrameLabel -> 
             Style["f (Hz)", 16, Italic], PlotStyle -> {Red, 
               AbsoluteThickness[2]}, PlotRange -> {{-5, 5}, All}, 
             ImageSize -> {400, 200}, AspectRatio -> 0.35]}, Alignment -> 
           Left, Spacings -> 1]}]), "Specifications" :> {
        Style["NMR Signal and Spectrum", 15, 
         RGBColor[0, 0, 1], Bold], Delimiter, 
        Style["Parameters of Signal", 15, 
         RGBColor[0, 0, 1], 
         Bold], {{$CellContext`Td$$, 0, "Delay Time, Td/s"}, 0, 2., 0.001, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`t0$$, 2, "Acquition time"}, 0.01, 10, 0.01, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`n$$, 20, "Number of Data Points"}, 10, 100, 1,
          Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`A$$, 0.25, "Amplitude"}, 0.01, 1, 0.01, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`w0$$, 1, "Peak Position"}, -5, 5, 0.1, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`\[Psi]$$, 0, "Initial Phase/\[Degree]"}, 0, 
         360, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`\[Psi]c$$, 0, "Phase correction/\[Degree]"}, 
         0, 360, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`T2$$, 2, "T2 relaxation of nuclear"}, 0.1, 5, 
         0.01, Appearance -> "Labeled", ImageSize -> Small}, Delimiter, 
        Style["Window Functions", 15, 
         RGBColor[0, 0, 1], Bold], 
        Delimiter, {{$CellContext`lb$$, 0, "Exponential Apodization"}, 0, 2, 
         0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`c$$, 4, "Gausiian Apodization (Variance)"}, 
         0.1, 4, 0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`b$$, 0, "Gaussian Variance (Shift)"}, -10, 10,
          0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`d$$, 0, "Sine Function (Peoredical)"}, 0, 1, 
         0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`\[CurlyPhi]$$, 0, "Sine Function (Shift)"}, 0,
          2, 0.01, Appearance -> "Labeled", ImageSize -> Small}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{1143., {257., 263.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`t = 0.09150000000000001}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.538022753912613*^9, 3.53802277372241*^9}, 
   3.538024152362318*^9, 3.538024200096382*^9, {3.538071677132861*^9, 
   3.538071706041917*^9}, 3.538072869165309*^9, {3.538072917586121*^9, 
   3.538072928870421*^9}, 3.5387097090526037`*^9}]
}, Open  ]]
},
WindowSize->{1280, 686},
WindowMargins->{{0, Automatic}, {Automatic, 81}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 23590, 520, 1233, "Input"],
Cell[24172, 544, 11013, 200, 537, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
